/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.rendimientos;

import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Retenido
extends Sujeto
implements Importable {
    private static final long serialVersionUID = -7165096025356786368L;
    public static final String C_PARTE_RELACIONADA = "descripcionRetenido";
    private boolean parteRelacionada;

    public Retenido() {
        this.parteRelacionada = false;
    }

    public Retenido(String string, String string2, String txVentas) {
        super(string, string2, txVentas);
    }

    @Override
    public Retenido crearCopiaEdicion() {
        Retenido copia = new Retenido();
        copia.setTipoIdentificacion(super.getTipoIdentificacion());
        copia.setIdentificacion(super.getIdentificacion());
        copia.setDescripcionTipoIdentificacion(super.getDescripcionTipoIdentificacion());
        copia.setParteRelacionada(this.parteRelacionada);
        copia.setTipoProveedor(super.getTipoProveedor());
        copia.setDescripcionTipoProveedor(super.getDescripcionTipoProveedor());
        copia.setRazonSocial(super.getRazonSocial());
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(Sujeto copiaEdicion) {
        Retenido comprador = (Retenido)copiaEdicion;
        this.setParteRelacionada(comprador.parteRelacionada);
        super.actualizarInformacion(copiaEdicion);
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("retenido");
        Element eValor = (Element)valorList.item(0);
        this.setTipoIdentificacion(UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacionSecuencia("6", eValor.getTextContent().trim()));
        this.setDescripcionTipoIdentificacion(Constantes.CATALOGOS_SUJETO.get(this.getTipoIdentificacion()));
        valorList = elemento.getElementsByTagName("idRetenido");
        eValor = (Element)valorList.item(0);
        this.setIdentificacion(eValor.getTextContent().trim());
        if (Util.existeElementoImportar(elemento, "parteRelFid")) {
            valorList = elemento.getElementsByTagName("parteRelFid");
            eValor = (Element)valorList.item(0);
            this.setParteRelacionada(Util.importarBooleano(eValor));
        }
        if (Util.existeElementoImportar(elemento, "tipoRete")) {
            valorList = elemento.getElementsByTagName("tipoRete");
            eValor = (Element)valorList.item(0);
            this.setTipoProveedor(eValor.getTextContent().trim());
            this.setDescripcionTipoProveedor(UtilCatalogosATS.obtenerNombreDetalleCatalogo((String)"TIPOSIDPROV", (String)this.getTipoProveedor()));
        }
        if (Util.existeElementoImportar(elemento, "denoBenefi")) {
            valorList = elemento.getElementsByTagName("denoBenefi");
            eValor = (Element)valorList.item(0);
            this.setRazonSocial(eValor.getTextContent().trim());
        }
        return this;
    }

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        Iva iva = (Iva)this.getRaizModelo();
        if (iva.periodo.isAnexoEnPeriodoDesdeMayo2016() && "P".equals(this.getTipoIdentificacion())) {
            if (this.getTipoProveedor() == null) {
                resultado.fallarValidacion("Debe seleccionar el tipo de cliente");
                return resultado;
            }
            resultado = this.validarRazonSocial(iva.periodo, "retenido", resultado);
        }
        return resultado;
    }

    public boolean isParteRelacionada() {
        return this.parteRelacionada;
    }

    public String getParteRelacionada() {
        return this.parteRelacionada ? "SI" : "NO";
    }

    public void setParteRelacionada(boolean parteRelacionada) {
        boolean oldValue = this.parteRelacionada;
        this.parteRelacionada = parteRelacionada;
        this.firePropertyChange(C_PARTE_RELACIONADA, oldValue, this.parteRelacionada);
    }
}

